import { Logger, transports } from 'winston';
import * as fs from 'fs';
export class WinstonLibrary {
/**
 * Represents a book.
 * @constructor
 */
	 constructor(private loggingDir, public logger = new (Logger)({
			transports: [
				new transports.Console ({ 
					level: 'info',
		  			prettyPrint: true,
		  			colorize: true,
		  			silent: false,
		  			timestamp: true 
				}),
				new transports.File ({ 
					filename: loggingDir + '\\' + 'protractor.test.exec.log' 
				})
			],
			levels: {
				trace: 0,
				input: 1,
				verbose: 2,
				prompt: 3,
				debug: 4,
				info: 5,
				data: 6,
				help: 7,
				warn: 8,
				error: 9
			},
			colors: {
				trace: 'magenta',
				input: 'grey',
				verbose: 'cyan',
				prompt: 'grey',
				debug: 'blue',
				info: 'green',
				data: 'grey',
				help: 'cyan',
				warn: 'yellow',
				error: 'red'
			}
		})
	 	, private logFileCleanUpOnStartup = true
	 	, private logID = 0){
	 }

	log(lvl: string, msg: string, type: string) {
		if (this.isFirstLoggingInstance() && this.getLogFileCleanUpOnStartup()) {
			this.createLogDir(this.loggingDir);
			this.clearLog();
		}	
		this.logger.log(lvl, msg, { type: type });
		this.incrementLogID();
		//Log could be sorted here...  Into high-level Outline and Detailed Actual
	}

//BetweenTestsRuns
	setLogFileCleanUpOnStartup(trueOrFalse = true) {
		if (trueOrFalse === true) {
			this.logFileCleanUpOnStartup = true;
		}
    	else if (trueOrFalse === false) {
			this.logFileCleanUpOnStartup = false;
		}  	 
    	else {
    		// @TO-DO: throw err -  expected only ever going to have a true or false value or will automatically type-convert to true/false - but value was typeof: + "" + 'could not set the value.'
		}
	}

	getLogFileCleanUpOnStartup() {
		return this.logFileCleanUpOnStartup;
	}

	isFirstLoggingInstance() {
		if (this.getLogID() === 0) {
			return true;
		}
    	else {
    		return false;		
		}
	}

	incrementLogID() {
		this.logID ++;	
	}

	getLogID() {
		return this.logID;	
	}
/**
Syntax
Following is the syntax of the method to truncate an opened file −

fs.ftruncate(fd, len, callback)
Parameters
Here is the description of the parameters used −

fd − This is the file descriptor returned by fs.open().

len − This is the length of the file after which the file will be truncated.

callback − This is the callback function No arguments other than a possible exception are given to the completion callback.
*/
	clearLog() {
		fs.unlink(this.loggingDir + 'protractor.test.exec.log', function(err) {
		   if (err) {
		      return console.error(err);
		   }
		});
	}
	
	createLogDir(dir) {
		if (!fs.existsSync(dir)) {
			console.log('Making Directory:' + dir);
			fs.mkdirSync(dir);	
		}
		else {
			console.log('Directory:' + dir + ' already exists skipping step "fs.mkdirSync".');
		}
	}
}	